﻿var auditLogs = {
    context: $(".v-auditLogs"),
    datatable: null,
    refreshDataTable: function () {
        auditLogs.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-auditLogsTable", auditLogs.context).a4datatable({
            height: "full",
            stateKey: "DiagnosticsAuditLogs",
            ajaxAction: a4.getAction("GetAuditLogs", "Diagnostics", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id" },
                { "Name": "Date", "Title": resources.Date, "Data": "Date", "Type": "datetime" },
                { "Name": "UserId", "Title": resources.UserId, "Data": "UserId" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "Action", "Title": resources.Type, "Data": "Action", "Type": "enum", "EnumType": "AuditLogAction" },
                { "Name": "Area", "Title": resources.Area, "Data": "Area" },
                { "Name": "RecordId", "Title": resources.RecordId, "Data": "RecordId" },
                { "Name": "Property", "Title": resources.Property, "Data": "Property" },
                { "Name": "PreviousValue", "Title": resources.PreviousValue, "Data": "PreviousValue" },
                { "Name": "CurrentValue", "Title": resources.CurrentValue, "Data": "CurrentValue" }
            ],
            localizableTexts: { "Search": resources.SearchRequestLogs },
            defaultSorting: { Column: "Id", Ascending: false },
            advancedFilter: true
        });
    },
    bindEvents: function () {
        auditLogs.context.on("click", ".h-exportLogs", function () {
            var tableParams = auditLogs.datatable.a4datatable("getTableParams");
            var link = a4.getAction("ExportAuditLogs", "Diagnostics", "Settings", { tableParams: JSON.stringify(tableParams) });

            a4.showBusyBox();

            a4.callServerMethod(link, {},
            function (result) {
                a4.hideBusyBox();
                window.location = a4.getAction("GetExportAuditLogsFile", "Diagnostics", "Settings", { filename: result });
            },
            function (error) {
                a4.onAjaxPageMethodError(error);
            });
        });
    }
}

$(document).ready(function () {
    if (auditLogs.context.length > 0) {
        auditLogs.initializeDataTable();
        auditLogs.bindEvents();
    }
});


